/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'jquerymobile', 'hbs!modules/navigation/panelNavigationItem' ],
    function (Portal, Backbone, Marionette, $, jqm, template) {
    return Backbone.Marionette.ItemView.extend({
        tagName: 'li',
        attributes: {
            "data-iconpos": "left"
        },
        template : template,
        initialize: function () {
            var icon;
            if (this.model.get('type') === 'App') {
                icon = "grid";
            } else if (this.model.get('type') === 'Applet') {
                icon = "arrow-r";
            } else if (this.model.get('type') === 'Link') {
                //icon = "star";
                icon = "arrow-r";
            }
            this.$el.attr('data-icon', icon);

            if (!this.model.get('display')) {
                this.$el.hide();
            }
        }
    });
});